/**
* \file: app_iface_extern.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_APP_IFACE_APP_IFACE_EXTERN_H
#define AAM_APP_IFACE_APP_IFACE_EXTERN_H

#include "model/device.h"
#include "model/partition.h"
#include "app_iface/socket_server.h"

#include "ipc/request_messages.h"

typedef struct app_iface_request_ctx_t
{
	int request_id;
	void *remote_callback_ptr;
	connection_ctx_t *ctx;
} app_iface_request_ctx_t;

typedef struct
{
	void (*on_device_detected)(device_t *device);

	void (*on_device_nomedia)(device_t *device);

	void (*on_device_automounting)(device_t *device);

	void (*on_device_automounted)(device_t *device);

	void (*on_device_unmounting)(device_t *device);

	void (*on_device_unmounted)(device_t *device);

	void (*on_device_invalid)(device_t *device);


	void (*on_partition_detected)(partition_t *partition);

	void (*on_partition_unsupported)(partition_t *partition);

	void (*on_partition_mounting)(partition_t *partition);

	void (*on_partition_mounted)(partition_t *partition);

	void (*on_partition_mount_err)(partition_t *partition);

	void (*on_partition_remounting)(partition_t *partition);

	void (*on_partition_unmounting)(partition_t *partition);

	void (*on_partition_unmounted)(partition_t *partition);

	void (*on_partition_invalid)(partition_t *partition);
} app_iface_event_callbacks_t;

error_code_t app_iface_unmount_mountpoint_request(const char *mount_point,
        partition_state_change_callback_t callback_func,app_iface_request_ctx_t *request_ctx);

error_code_t app_iface_unmount_partition_request(const char *partition_id,
        partition_state_change_callback_t callback_func,app_iface_request_ctx_t *request_ctx);

error_code_t app_iface_unmount_device_request(const char *device_id,
        device_state_change_callback_t callback_func,app_iface_request_ctx_t *request_ctx);

error_code_t app_iface_remount_request_mp(const char *mount_point, const char *mount_options,
		partition_state_change_callback_t callback_func,app_iface_request_ctx_t *request_ctx);

error_code_t app_iface_remount_request_id(const char *partition_id, const char *mount_options,
		partition_state_change_callback_t callback_func,app_iface_request_ctx_t *request_ctx);

void app_iface_register_event_callbacks(const app_iface_event_callbacks_t *event_callbacks);

void app_iface_extract_part_info(partition_info_t *part_info,partition_t *partition);

void app_iface_extract_dev_info(device_info_t *device_info,device_t *device);

#endif
